package gov.va.med.mhv.getcare.repository;

import gov.va.med.mhv.getcare.model.TreatmentFacility;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface TreatmentFacilityRepository extends JpaRepository<TreatmentFacility, Long> {

	@Query("select t from TreatmentFacility t where t.userProfileId = :userProfileId order by UPPER(t.facilityName) asc")
	public List<TreatmentFacility> findFacilitiesForUser(@Param("userProfileId") Long userProfileId);
		
	@Query("select t from TreatmentFacility t where t.userProfileId = :userProfileId order by UPPER(t.facilityName) asc")
	public List<TreatmentFacility> findDashboardFacilitiesForUser(@Param("userProfileId") Long userProfileId,Pageable page);
	
	
	@Query("select t from TreatmentFacility t where t.userProfileId = :userProfileId and t.homeFacility = 1")
	public List<TreatmentFacility> findHomeFacility(@Param("userProfileId") Long userProfileId);
}
